/*
 * Decompiled with CFR 0.152.
 */
package com.renyigesai.immortalers_delight.event;

import com.renyigesai.immortalers_delight.Config;
import com.renyigesai.immortalers_delight.api.mobbase.ImmortalersMob;
import com.renyigesai.immortalers_delight.init.ImmortalersDelightMobEffect;
import com.renyigesai.immortalers_delight.init.ImmortalersDelightTags;
import com.renyigesai.immortalers_delight.util.DifficultyModeUtil;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraftforge.event.entity.living.LivingDamageEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber
public class DifficultyModeEventHelper {
    private static final Map<UUID, Float> entityDeathless = new ConcurrentHashMap<UUID, Float>();

    @SubscribeEvent
    public static void ImmortalrsMobAttackProgressDamage(LivingHurtEvent event) {
        LivingEntity attacker;
        Entity entity;
        LivingEntity hurtOne = event.getEntity();
        if (!hurtOne.m_9236_().f_46443_ && DifficultyModeUtil.isPowerBattleMode() && Config.powerBattleModeStrengthenTheEnemies && (entity = event.getSource().m_7639_()) instanceof LivingEntity && ((attacker = (LivingEntity)entity).m_6095_().m_204039_(ImmortalersDelightTags.IMMORTAL_NORMAL_MOBS) || attacker.m_6095_().m_204039_(ImmortalersDelightTags.IMMORTAL_ELITE_MOBS) || attacker.m_6095_().m_204039_(ImmortalersDelightTags.IMMORTAL_MID_BOSS))) {
            float oldDamage = event.getAmount();
            float buffer = Math.min(3.0f, 1.0f + hurtOne.m_21233_() * 0.02f);
            event.setAmount(Math.max(oldDamage * buffer, 0.0f));
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void ImmortalrsMobAttackMinDamage(LivingDamageEvent event) {
        Entity entity;
        if (DifficultyModeUtil.isPowerBattleMode() && Config.powerBattleModeStrengthenTheEnemies && (entity = event.getSource().m_7639_()) instanceof LivingEntity) {
            LivingEntity attacker = (LivingEntity)entity;
            if (!attacker.m_9236_().f_46443_) {
                ImmortalersMob immMob;
                LivingEntity hurtOne = event.getEntity();
                float minDamage = 0.0f;
                boolean needMinDamage = false;
                if (attacker.m_6095_().m_204039_(ImmortalersDelightTags.IMMORTAL_NORMAL_MOBS)) {
                    if (attacker instanceof ImmortalersMob) {
                        immMob = (ImmortalersMob)attacker;
                        minDamage += immMob.getMinDamage();
                    } else {
                        minDamage += 1.0f;
                    }
                    needMinDamage = true;
                }
                if (attacker.m_6095_().m_204039_(ImmortalersDelightTags.IMMORTAL_ELITE_MOBS)) {
                    if (attacker instanceof ImmortalersMob) {
                        immMob = (ImmortalersMob)attacker;
                        minDamage += immMob.getMinDamage();
                    } else {
                        minDamage += 2.0f;
                    }
                    needMinDamage = true;
                }
                if (attacker.m_6095_().m_204039_(ImmortalersDelightTags.IMMORTAL_MID_BOSS)) {
                    if (attacker instanceof ImmortalersMob) {
                        immMob = (ImmortalersMob)attacker;
                        minDamage += immMob.getMinDamage();
                    } else {
                        minDamage += 2.5f;
                    }
                    needMinDamage = true;
                }
                if (hurtOne.m_21023_((MobEffect)ImmortalersDelightMobEffect.VULNERABLE.get())) {
                    int amplifier = Objects.requireNonNull(hurtOne.m_21124_((MobEffect)ImmortalersDelightMobEffect.VULNERABLE.get())).m_19564_();
                    minDamage *= (float)(amplifier + 2);
                }
                if (needMinDamage && minDamage > 0.0f) {
                    event.setAmount(event.getAmount() + minDamage);
                }
            }
        }
    }

    @SubscribeEvent
    public static void ImmortalrsMobHurtDamageDecay(LivingDamageEvent event) {
        if (DifficultyModeUtil.isPowerBattleMode() && Config.powerBattleModeStrengthenTheEnemies) {
            LivingEntity hurtOne = event.getEntity();
            if (!hurtOne.m_9236_().f_46443_) {
                ImmortalersMob immMob;
                float oldDamage;
                float damage = oldDamage = event.getAmount();
                float damageDivisor = 0.0f;
                boolean needLimitDamage = false;
                if (hurtOne.m_6095_().m_204039_(ImmortalersDelightTags.IMMORTAL_NORMAL_MOBS)) {
                    damageDivisor = 0.04f;
                    if (hurtOne instanceof ImmortalersMob) {
                        immMob = (ImmortalersMob)hurtOne;
                        damageDivisor = immMob.getDamageDivisor();
                    }
                    if (oldDamage > 100.0f * damageDivisor) {
                        float buffer = Math.min(7.0f, 1.0f + damageDivisor * (oldDamage - 100.0f * damageDivisor));
                        damage = oldDamage / buffer;
                        needLimitDamage = true;
                    }
                }
                if (hurtOne.m_6095_().m_204039_(ImmortalersDelightTags.IMMORTAL_ELITE_MOBS)) {
                    damageDivisor = 0.05f;
                    if (hurtOne instanceof ImmortalersMob) {
                        immMob = (ImmortalersMob)hurtOne;
                        damageDivisor = immMob.getDamageDivisor();
                    }
                    if (oldDamage > 100.0f * damageDivisor) {
                        float buffer = Math.min(11.0f, 1.0f + damageDivisor * (oldDamage - 100.0f * damageDivisor));
                        damage = oldDamage / buffer;
                        needLimitDamage = true;
                    }
                }
                if (hurtOne.m_6095_().m_204039_(ImmortalersDelightTags.IMMORTAL_MID_BOSS)) {
                    damageDivisor = 0.08f;
                    if (hurtOne instanceof ImmortalersMob) {
                        ImmortalersMob immMob2 = (ImmortalersMob)hurtOne;
                        damageDivisor = immMob2.getDamageDivisor();
                    }
                    if (oldDamage > 100.0f * damageDivisor) {
                        float buffer = Math.min(15.0f, 1.0f + damageDivisor * (oldDamage - 100.0f * damageDivisor));
                        damage = oldDamage / buffer;
                        needLimitDamage = true;
                    }
                }
                if (needLimitDamage) {
                    event.setAmount(damage);
                }
            }
        }
    }
}

